unit SkeletonForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  types, StdCtrls, pub;

type
  TSkeleton = class(TForm)
    Memo1: TMemo;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    function SearchComponent(iTag : Word) : TComponent;
    function CelsiusToFahrenHeit(dCelsius : Double) : Double;
  public
    { Public declarations }
    procedure GetPosInfo(indx : Integer);
    procedure SavePosInfo(var msg : TMessage); message WM_SavePosition;
    procedure TempNotify (var msg : TMessage); message WM_TempNotify;
    procedure AlarmNotify (var msg : TMessage);    message WM_AlarmNotify;
    procedure AverageNotify (var msg : TMessage);  message WM_AvgTempNotify;
    procedure AlarmReNotify (var msg : TMessage); message WM_AlarmReNotify;
    procedure SlopeNotify (var msg : TMessage);   message WM_SlopeNotify;
    procedure PollNotify (var msg : TMessage);    message WM_PollNotify;
  end;

var
  Skeleton: TSkeleton;

implementation

{$R *.DFM}

function TSkeleton.SearchComponent(iTag : Word) : TComponent;
var   i : Integer;
begin
{
   Search component that has desired Tag
}
   result := nil;
   for i := 1 to ComponentCount do
      if (Components[i-1]).Tag = iTag then
         result := (Components[i-1]);
end;

function TSkeleton.CelsiusToFahrenHeit(dCelsius : Double) : Double;
begin
   result := dCelsius * 9/5 +32;
end;

procedure TSkeleton.GetPosInfo(indx : Integer);
begin
   Top := pub.RegGetInt('Windows',IntToStr(indx),'Top',0);
   Left := pub.RegGetInt('Windows',IntToStr(indx),'Left',0);
   Width := pub.RegGetInt('Windows',IntToStr(indx),'Width',350);
   Height := pub.RegGetInt('Windows',IntToStr(indx),'Height',350);
   ShowWindow(Handle,pub.RegGetInt('Windows',IntToStr(indx),'State',SW_SHOWNORMAL));
end;

procedure TSkeleton.SavePosInfo(var msg : TMessage);
var indx : Integer;
    DLLFileName : array[0..MAX_PATH] of char;
begin
   //Mandatory
   //Get the DLL filename with full path first
   //hInstance is the handle provided by Windows for an application or library.
   FillChar(DLLFileName, sizeof(DLLFileName), #0);
   GetModuleFileName(hInstance, DLLFileName, sizeof(DLLFileName));

   indx := msg.LParam;
   pub.RegPutInt('Windows',IntToStr(indx),'Type',99); // Type must be 99
   pub.RegPutString('Windows',IntToStr(indx),'Plugin',ExtractFileName(DLLFileName));
   pub.SaveWindowPos(Handle,indx);
end;

procedure TSkeleton.TempNotify (var msg : TMessage);
var dTemp   : Double;
    sTemp   : String;
begin
   //msg.WParam contains the Tag of the sensor
   //msg.LParam contains the temperature multiplied by 100 in Celsius
   dTemp := msg.lParam / 100;
   if dTemp > -998 then
   begin
      sTemp := FormatFloat('0.00',dTemp);
   end
   else
      // No updates for a long time
      sTemp := '-------';

   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Sensor: '+ IntToStr(msg.WParam)+
                    ' Temperature: ' + sTemp);
end;

procedure TSkeleton.AlarmNotify (var msg : TMessage);
var s : String;
begin
   //msg.WParam contains the Tag of the sensor
   //msg.LParam contains the alarm status
   case msg.LParam of
      0 : s := ' No alarm.';
      1 : s := ' Lo alarm.';
      2 : s := ' Hi alarm.';
   end;

   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Sensor: '+ IntToStr(msg.WParam)+ s);

end;

procedure TSkeleton.AverageNotify (var msg : TMessage);
begin
   //msg.WParam contains the Tag of the sensor
   //msg.LParam contains the average temperature multiplied by 100
   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Sensor: '+ IntToStr(msg.WParam)+
                    ' Average: ' + FormatFloat('0.00',msg.lParam / 100));
end;

procedure TSkeleton.AlarmReNotify (var msg : TMessage);
var s : String;
begin
   //msg.WParam contains the Tag of the sensor
   //msg.LParam contains the alarm status
   //When new child form is opened, mainthread asks for measurement thread to
   //send every sensors alarm status again.
   case msg.LParam of
      0 : s := ' No alarm.';
      1 : s := ' Lo alarm.';
      2 : s := ' Hi alarm.';
   end;

   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Sensor: '+ IntToStr(msg.WParam)+ s);
end;

procedure TSkeleton.SlopeNotify (var msg : TMessage);
var s : String;
begin
   //msg.WParam contains the Tag of the sensor
   //msg.LParam contains the slope status 0=Falling, 1=Raising
   case msg.LParam of
      0 : s := ' Slope end.';
      1 : s := ' Falling.';
      2 : s := ' Raising.';
   end;

   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Sensor: '+ IntToStr(msg.WParam)+ s);
end;


procedure TSkeleton.PollNotify (var msg : TMessage);
var s : String;
begin
   //msg.LParam contains polling status 0=Finished, 1=Started
   case msg.LParam of
      0 : s := 'finished.';
      1 : s := 'started.';
   end;

   Memo1.Lines.Add (FormatDateTime('hh:nn:ss.zzz',now)+
                    ' Polling ' + s);
end;

procedure TSkeleton.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

end.
